#include <p30fxxxx.h>
#include <spi.h>

/*****************************************************************************
*     Function Name :  putsSPI2                                              *
*     Description   :  This function writes the specified length of data     *
                       word/byte to be transmitted into the transmit buffer  *
*     Parameters    :  unsigned int: length of bytes/words to be written     *
                       unsigned int*:  Address ofthe location where the data *
                       to be transmitted is stored                           *
*     Return Value  :  None                                                  *                                                                
******************************************************************************/

/* The following devices support SPI2 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__)  || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) ||  defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__) || defined(__dsPIC30F5015__)   

void putsSPI2(unsigned int length, unsigned int *wrptr)
{  
    char *temp_ptr = (char *) wrptr;
    while (length)                   /* write byte/word until length is 0 */
    {           
        if(SPI2CONbits.MODE16)
            SPI2BUF = *wrptr++;      /* initiate SPI bus cycle by word write */ 
        else
            SPI2BUF = *temp_ptr++;   /* initiate SPI bus cycle by byte write */ 
        while(SPI2STATbits.SPITBF);  /* wait until 'SPITBF' bit is cleared */
        length--;                    /* decrement length */
    }
}

#endif
